/*
Dane wejsciowe (wlasnosci werteksu):
gl_Vertex - pooenie (we wsp. modelu), vec4
gl_Color - kolor, vec4
gl_Normal - normalna, vec3
gl_MultiTexCoord0 - wsprzdne teksturowania (indeks 0), vec4

Parametry:
gl_ModelViewProjectionMatrix = mul(gl_ProjectionMatrix,gl_ModelViewMatrix), mat4
gl_NormalMatrix, mat3 (transponowane elementy z gl_ModelViewMatrix przyciete do mat3)

Dane wyjsciowe (wlasnosci werteksu):
gl_Position - pozycja (obowizkowe!), vec4
gl_FrontColor - kolor, vec4
*/

bool KopiujKolorWerteksu = true;
bool PokazNormalne = false;

vec4 Ce  = vec4(0,0,0,0);
vec4 Ca  = vec4(1,1,1,1);
vec4 Cd  = vec4(1,1,1,1);
vec4 Cs  = vec4(1,1,1,1);

//vec4 Wa = vec4(0.3,0.3,0.3,1);
//vec4 Wd = vec4(0.6,0.6,0.6,1);
//vec4 Ws = vec4(1,1,1,1);
//float ns = 1;

float wa=0.3;
float wd=0.6;
float ws=0.5;
vec4 Wa = vec4(wa,wa,wa,1);
vec4 Wd = vec4(wd,wd,wd,1);
vec4 Ws = vec4(ws,ws,ws,1);
float ns = 10.0;

vec3 PozycjaZrodlaSwiatla = vec3(5,2,1);
vec3 PolozenieKamery = vec3(0,0,1);

//te wszystkie parametry powinny byc uniform

vec4 ObliczKolor()
{
    vec4 Kolor;    

    vec3 R=(gl_ModelViewMatrix*gl_Vertex).xyz;
    vec3 L=normalize(PozycjaZrodlaSwiatla-R);
    vec3 N=normalize(gl_NormalMatrix*gl_Normal);
    float dotLN=clamp(dot(L,N),0.0,1.0);	

    vec3 O = 2*dotLN*N-L;
    vec3 V = normalize(PolozenieKamery-R);
    float dotOVn = clamp(pow(clamp(dot(O,V),0.0,1.0),ns),0.0,1.0);

    if(KopiujKolorWerteksu)
    {
        Ca=gl_Color;
        Cd=gl_Color;
    }

    Kolor=clamp(Ce,0,1);
    Kolor+=clamp(Wa*Ca,0,1);
    Kolor+=clamp(Wd*Cd*dotLN,0,1);
    Kolor+=clamp(Ws*Cs*dotOVn,0,1);
    Kolor=clamp(Kolor,0,1);
    return Kolor;
}

void main(void)
{
    // przeksztacenia model-widok
    gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;   

    //model Phonga
    //gl_FrontColor = gl_Color;
    gl_FrontColor=ObliczKolor();
}
